% ==========================================================================
%  [MFCC,X] = melcep(x,win_func,frame_advance,fs,NumLinFilts,NumLogFilts)
% 
%  Description: This function computes the real mel cepstrum given a signal
%  and the desired parameters.
% 
%  Input Arguments:
% 	Name: x
% 	Type: vector (signal length x 1)
% 	Description: signal 
% 
% 	Name: win_func
% 	Type: vector (window-length x 1)
% 	Description: the desired windowing function 
% 
% 	Name: frame_advance
% 	Type: scalar
% 	Description: the frame advance in samples
% 
% 	Name: fs
% 	Type: scalar
% 	Description: sampling frequency
% 
% 	Name: NumLinFilts
% 	Type: scalar
% 	Description: number of linearly spaced filters
% 
% 	Name: NumLogFilts
% 	Type: scalar
% 	Description: number of logarithmicaly spaced filters
% 
%  Output Arguments:
% 	Name: MFCC
% 	Type:  matrix (window-length x number of frames)
% 	Description: the real mel cepstrum 
% 
% 	Name: X
% 	Type: matrix (window-length x number of frames)
% 	Description: the short-time Fourier transfrom of x
% 
% 	Name: x_k
% 	Type: matrix (window length x number of frames)
% 	Description: windowed and framed signal
% 
%  References:
% 
% --------------------------------------------------------------------------
%  Notes:
% 
%  
% 
% --------------------------------------------------------------------------
%  Author: Steven Sandoval
% 
%  This code may have been derived from codes by Phillip De Leon or Laura E.
%  Boucheron.
% 
%  Creation Date: June 2011
% 
% --------------------------------------------------------------------------
%  Revision History:
%  
% 
% ==========================================================================
%
